#version 330
#extension GL_EXT_gpu_shader4 : enable
//Hyperbolic FunMod01.fsh   by  decrooks
//https://www.shadertoy.com/view/lsffRN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by David Crooks
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#define TWO_PI 6.283185
#define PI 3.14159265359

struct Circle {
    float radius;
    vec2 center;
};

const int numCircles = 3;
Circle circles[3];


/*
	Orthoganl Circles represent strait line in hyperbolic space.
	
	see http://mathworld.wolfram.com/PoincareHyperbolicDisk.html.

*/
Circle orthogonalCircle(float theta1,float theta2) {
    
    float theta = 0.5*(theta1 + theta2);
    float dTheta = 0.5*(theta1 - theta2);
    
    float r = abs(tan(dTheta));
   //  float r = 0.5;
    float R = 1.0/cos(dTheta);
    
    vec2 center = vec2(R*cos(theta),R*sin(theta));
    
    return Circle(r,center);
}




void createCircles() {

    float t = 0.5 - 0.5*cos(iTime);

  	float theta = TWO_PI/3.0;
   
    
    float dTheta = 2.43 + 0.152*t;
    
	//for(int i;i<numCircles  )
    circles[0] = orthogonalCircle(0.0,dTheta);
    circles[1] = orthogonalCircle(theta,theta + dTheta);
    circles[2] = orthogonalCircle(2.0*theta,2.0*theta +  dTheta);
}

float arcosh(float x) {
    return log(x + sqrt(x*x - 1.0));
}

float hyperbolicDist(vec2 p, vec2 q){
    //distance between points on  Poincaré Hyperbolic Disk
    float pq = length(p-q);
    float op = length(p);
    float oq = length(q);
    
    return arcosh(1.0 + 2.0*pq*pq/((1.0 - op*op)*(1.0 - oq*oq)) );
}

bool circleContains(vec2 p, Circle c) {
    
   return distance(c.center,p) < c.radius;
    
}


/*
	Circle inversion exchanges the inside with the outside of a circle.
	Reflections in hyperbolic space.
*/
vec2 circleInverse(vec2 p, Circle c){
    
	return ((p - c.center) * c.radius * c.radius)/(length(p - c.center) * length(p - c.center) ) + c.center;
    
}

bool isEven(int i){
    
    return mod(float(i),2.0) == 0.0;
    
}

/*
	Iterated Inversion System 
    see this paper http://archive.bridgesmathart.org/2016/bridges2016-367.pdf
    and this shader https://www.shadertoy.com/view/XsVXzW by soma_arc.

	This algorythim for draws tileings on the poncaire disk model of hyperbolic space.
	
	Our array of circles represent the reflections that generate the tiling.
	We repeatedly invert the point in each of the circles and keep track of the total number of inversions.

*/

vec2 iteratedInversion(vec2 p) {
    

    int count = 0;
    bool flag = true;
    
    for(int i=0; i<100; i++) {
        
        flag = true;
        
        
        for(int j = 0; j<numCircles; j++) {
            Circle c = circles[j];

            if(circleContains(p, c)) {
                
                p = circleInverse(p,c);
                flag = false;
                count++;  
                
        	} 
            
        }
        
        if(flag) {
           break;
        }
        
    }
    
    //return isEven(count);
    return p;
    
}

float drawCircles(vec2 p) {
    
    float  d0 =  abs(distance(circles[0].center,p) - circles[0].radius);
    float  d1 = abs(distance(circles[1].center,p) - circles[1].radius);
    float  d2 =  abs(distance(circles[2].center,p) - circles[2].radius);
    
    float disk = abs(length(p) - 1.0);
   
    float d =  min(min(min(d0,d1),d2),disk);
    
    if(d<0.01) {
     	return 0.0;   
    }
    else {
        return 1.0 - 0.5*d;  
    }
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord)
{
	createCircles();
    
    vec2 uv = 2.0*(gl_FragCoord.xy - 0.5*iResolution.xy) / iResolution.y;
    
    float R = length(uv);
    
    vec4 black = vec4(vec3(0.0),1.0);
    vec4 white = vec4(1.0);
    
    
    //Uncomment this to see the circles that generate the tiling
    //gl_FragColor = vec4(vec3(drawCircles( uv)),1.0); return;
   
   
    if (R<1.0){
        vec2 p = iteratedInversion(uv);
       // float r = length(p);  //distance(p
        float r = hyperbolicDist(p,vec2(0.0));
        
        float h = sin(15.0*r + iTime);
        
          gl_FragColor = vec4(vec3(0.5+0.5*h),1.0);
    }
    else {
        gl_FragColor = white;
        gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );
    }
}